﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

using System.Threading;

namespace KontekstSynchronizacji_WPF
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        static int min = 0;
        static int max = 100;
        static int opoznienie = 100;

        public MainWindow()
        {
            InitializeComponent();
        }

        private void ResetujInterfejs(object sender, RoutedEventArgs e)
        {
            progressBar1.Minimum = min;
            progressBar1.Maximum = max;
            progressBar1.Value = min;
            button1.Content = "Kontekst synchronizacji";
        }

        private void ustawWartoscPaskaPostepu_KontekstSynchronizacji(object parametr)
        {
            //to dziala w watku UI
            int nowaWartosc = (int)parametr;
            progressBar1.Value = nowaWartosc;
        }

        private void kontrolaPaskaPostepu_KontekstSynchronizacji(object parametr)
        {
            //MessageBox.Show(SynchronizationContext.Current.ToString());

            SynchronizationContext kontekst = parametr as SynchronizationContext;

            for (int i = min; i <= max; i++)
            {
                try
                {
                    //uruchamia funkcje zwrotna w wątku okna i czeka na jego zakonczenie
                    //wyjątek pojawi się tutaj
                    kontekst.Send(ustawWartoscPaskaPostepu_KontekstSynchronizacji, i);
                    //kontekst.Send((object nowaWartosc) => { progressBar1.Value = (int)nowaWartosc; }, i);
                }
                catch (Exception exc)
                {
                    MessageBox.Show("Wyjątek: " + exc.Message);
                }
                Thread.Sleep(opoznienie);
            }
            kontekst.Send((object niewykorzystany) => { button1.Content = "Koniec"; }, null);
        }

        private void Button_Click_3(object sender, RoutedEventArgs e)
        {
            //MessageBox.Show(SynchronizationContext.Current.ToString());

            SynchronizationContext kontekst = SynchronizationContext.Current;

            //watek z kontekstem synchronizacji
            Thread t = new Thread(kontrolaPaskaPostepu_KontekstSynchronizacji);
            t.Start(kontekst);

            //zakleszczenie przy sens
            //t.Join();
            //button3.Content = "Zakleszczenie";
        }
    }
}
